/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.loader;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingLoader2
implements MappingLoader {
    private ClassLoader _loader;
    private boolean _allowRedefinitions = false;
    private boolean _loaded = false;
    private List<ClassDescriptor> _descriptors = new Vector<ClassDescriptor>();
    private Map<String, ClassDescriptor> _descriptorsByClassname = new Hashtable<String, ClassDescriptor>();

    public AbstractMappingLoader2(ClassLoader loader) {
        this.setClassLoader(loader);
    }

    @Override
    public final void clear() {
        this._allowRedefinitions = false;
        this._loaded = false;
        this._descriptors.clear();
        this._descriptorsByClassname.clear();
    }

    @Override
    public final void setClassLoader(ClassLoader loader) {
        this._loader = loader == null ? this.getClass().getClassLoader() : loader;
    }

    @Override
    public final ClassLoader getClassLoader() {
        return this._loader;
    }

    public final void setAllowRedefinitions(boolean allow) {
        this._allowRedefinitions = allow;
    }

    public final boolean isAllowRedefinition() {
        return this._allowRedefinitions;
    }

    protected final void addDescriptor(ClassDescriptor descriptor) throws MappingException {
        String classname = descriptor.getJavaClass().getName();
        if (this._descriptorsByClassname.containsKey(classname)) {
            if (!this.isAllowRedefinition()) {
                throw new MappingException("mapping.duplicateDescriptors", classname);
            }
            Iterator<ClassDescriptor> iterator = this._descriptors.iterator();
            while (iterator.hasNext()) {
                ClassDescriptor d = iterator.next();
                if (!classname.equals(d.getJavaClass().getName())) continue;
                iterator.remove();
            }
            this._descriptors.add(descriptor);
        } else {
            this._descriptors.add(descriptor);
        }
        this._descriptorsByClassname.put(classname, descriptor);
    }

    @Override
    public final ClassDescriptor getDescriptor(String classname) {
        if (classname == null) {
            return null;
        }
        return this._descriptorsByClassname.get(classname);
    }

    @Override
    public final List<ClassDescriptor> getDescriptors() {
        return this._descriptors;
    }

    protected final boolean loadMapping() {
        if (this._loaded) {
            return false;
        }
        this._loaded = true;
        return true;
    }
}

