/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.data.RewindableDataSourceProvider;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRAbstractTextDataSource;
import net.sf.jasperreports.engine.data.JsonData;
import net.sf.jasperreports.engine.data.JsonDataCollection;
import net.sf.jasperreports.engine.data.TextDataSourceAttributes;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractJsonQueryExecuter<T extends JRAbstractTextDataSource>
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(AbstractJsonQueryExecuter.class);
    private JsonData datasource;

    public AbstractJsonQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
        this.parseQuery();
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        TextDataSourceAttributes textAttributes = this.getTextAttributes();
        InputStream jsonInputStream = (InputStream)this.getParameterValue("JSON_INPUT_STREAM");
        if (jsonInputStream != null) {
            T jsonDatasource = this.getJsonDataInstance(jsonInputStream);
            ((JRAbstractTextDataSource)jsonDatasource).setTextAttributes(textAttributes);
            this.datasource = (JsonData)jsonDatasource;
        } else {
            String jsonSource = this.getStringParameterOrProperty("net.sf.jasperreports.json.source");
            if (jsonSource != null) {
                T jsonDatasource = this.getJsonDataInstance(jsonSource);
                ((JRAbstractTextDataSource)jsonDatasource).setTextAttributes(textAttributes);
                this.datasource = (JsonData)jsonDatasource;
            } else {
                List jsonSources = (List)this.getParameterValue("net.sf.jasperreports.json.sources", true);
                if (jsonSources != null) {
                    ArrayList<RewindableDataSourceProvider<T>> jsonProviders = new ArrayList<RewindableDataSourceProvider<T>>(jsonSources.size());
                    for (String source : jsonSources) {
                        RewindableDataSourceProvider<T> jsonProvider = this.getJsonDataProviderInstance(source, textAttributes);
                        jsonProviders.add(jsonProvider);
                    }
                    this.datasource = new JsonDataCollection(jsonProviders);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"No JSON source was provided.");
                }
            }
        }
        return this.datasource;
    }

    protected abstract T getJsonDataInstance(InputStream var1) throws JRException;

    protected abstract T getJsonDataInstance(String var1) throws JRException;

    protected abstract RewindableDataSourceProvider<T> getJsonDataProviderInstance(String var1, TextDataSourceAttributes var2);

    protected TextDataSourceAttributes getTextAttributes() {
        Locale jsonLocale;
        String numberFormatPattern;
        TextDataSourceAttributes attributes = new TextDataSourceAttributes();
        String dateFormatPattern = this.getStringParameterOrProperty("net.sf.jasperreports.json.date.pattern");
        if (dateFormatPattern != null) {
            attributes.setDatePattern(dateFormatPattern);
        }
        if ((numberFormatPattern = this.getStringParameterOrProperty("net.sf.jasperreports.json.number.pattern")) != null) {
            attributes.setNumberPattern(numberFormatPattern);
        }
        if ((jsonLocale = (Locale)this.getParameterValue("JSON_LOCALE", true)) != null) {
            attributes.setLocale(jsonLocale);
        } else {
            String jsonLocaleCode = this.getStringParameterOrProperty("net.sf.jasperreports.json.locale.code");
            if (jsonLocaleCode != null) {
                attributes.setLocale(jsonLocaleCode);
            }
        }
        TimeZone jsonTimezone = (TimeZone)this.getParameterValue("JSON_TIME_ZONE", true);
        if (jsonTimezone != null) {
            attributes.setTimeZone(jsonTimezone);
        } else {
            String jsonTimezoneId = this.getStringParameterOrProperty("net.sf.jasperreports.json.timezone.id");
            if (jsonTimezoneId != null) {
                attributes.setTimeZone(jsonTimezoneId);
            }
        }
        return attributes;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean cancelQuery() throws JRException {
        return false;
    }
}

