/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components;

import java.io.IOException;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentXmlWriter;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.VersionComparator;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public abstract class AbstractComponentXmlWriter
implements ComponentXmlWriter {
    public static final String PROPERTY_COMPONENTS_PREFIX = "net.sf.jasperreports.components.";
    public static final String PROPERTY_COMPONENTS_VERSION_SUFFIX = ".version";
    protected final JasperReportsContext jasperReportsContext;
    protected final VersionComparator versionComparator;

    public AbstractComponentXmlWriter(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
        this.versionComparator = new VersionComparator();
    }

    public static String getVersion(JasperReportsContext jasperReportsContext, JRComponentElement componentElement, JRXmlWriter reportWriter) {
        String version = null;
        ComponentKey componentKey = componentElement.getComponentKey();
        String versionProperty = PROPERTY_COMPONENTS_PREFIX + componentKey.getName() + PROPERTY_COMPONENTS_VERSION_SUFFIX;
        if (componentElement.getPropertiesMap().containsProperty(versionProperty)) {
            version = componentElement.getPropertiesMap().getProperty(versionProperty);
        } else {
            JRReport report = reportWriter.getReport();
            version = JRPropertiesUtil.getInstance(jasperReportsContext).getProperty(report, versionProperty);
            if (version == null) {
                version = JRPropertiesUtil.getInstance(jasperReportsContext).getProperty(report, "net.sf.jasperreports.report.version");
            }
        }
        return version;
    }

    protected boolean isNewerVersionOrEqual(JRComponentElement componentElement, JRXmlWriter reportWriter, String oldVersion) {
        return this.versionComparator.compare(AbstractComponentXmlWriter.getVersion(this.jasperReportsContext, componentElement, reportWriter), oldVersion) >= 0;
    }

    protected boolean isOlderVersionThan(JRComponentElement componentElement, JRXmlWriter reportWriter, String version) {
        return this.versionComparator.compare(AbstractComponentXmlWriter.getVersion(this.jasperReportsContext, componentElement, reportWriter), version) < 0;
    }

    protected void writeExpression(String name, JRExpression expression, boolean writeClass, JRComponentElement componentElement, JRXmlWriter reportWriter) throws IOException {
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        if (this.isNewerVersionOrEqual(componentElement, reportWriter, "4.1.1")) {
            writer.writeExpression(name, expression);
        } else {
            writer.writeExpression(name, expression, writeClass);
        }
    }

    protected void writeExpression(String name, XmlNamespace namespace, JRExpression expression, boolean writeClass, JRComponentElement componentElement, JRXmlWriter reportWriter) throws IOException {
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        if (this.isNewerVersionOrEqual(componentElement, reportWriter, "4.1.1")) {
            writer.writeExpression(name, namespace, expression);
        } else {
            writer.writeExpression(name, namespace, expression, writeClass);
        }
    }
}

