/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.analytics.dataset;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.analytics.dataset.BucketOrder;
import net.sf.jasperreports.engine.analytics.dataset.DataLevelBucket;
import net.sf.jasperreports.engine.analytics.dataset.DataLevelBucketProperty;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class BaseDataLevelBucket
implements DataLevelBucket,
Serializable {
    private static final long serialVersionUID = 10200L;
    public static final String EXCEPTION_MESSAGE_KEY_BUCKET_LOAD_ERROR = "engine.analytics.dataset.bucket.load.error";
    protected String valueClassName;
    protected String valueClassRealName;
    protected Class<?> valueClass;
    @Deprecated
    protected SortOrderEnum orderValue = null;
    protected BucketOrder order = BucketOrder.ASCENDING;
    protected JRExpression expression;
    protected JRExpression labelExpression;
    protected JRExpression comparatorExpression;
    protected List<DataLevelBucketProperty> bucketProperties;

    protected BaseDataLevelBucket() {
        this.bucketProperties = new ArrayList<DataLevelBucketProperty>();
    }

    public BaseDataLevelBucket(DataLevelBucket bucket, JRBaseObjectFactory factory) {
        factory.put(bucket, this);
        this.valueClassName = bucket.getValueClassName();
        this.order = bucket.getOrder();
        this.expression = factory.getExpression(bucket.getExpression());
        this.labelExpression = factory.getExpression(bucket.getLabelExpression());
        this.comparatorExpression = factory.getExpression(bucket.getComparatorExpression());
        List<DataLevelBucketProperty> properties = bucket.getBucketProperties();
        this.bucketProperties = new ArrayList<DataLevelBucketProperty>(properties.size());
        for (DataLevelBucketProperty property : properties) {
            this.bucketProperties.add(factory.getDataLevelBucketProperty(property));
        }
    }

    @Override
    public String getValueClassName() {
        return this.valueClassName;
    }

    @Override
    @Deprecated
    public SortOrderEnum getOrderValue() {
        return BucketOrder.toSortOrderEnum(this.order);
    }

    @Override
    public BucketOrder getOrder() {
        return this.order;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    public JRExpression getLabelExpression() {
        return this.labelExpression;
    }

    @Override
    public JRExpression getComparatorExpression() {
        return this.comparatorExpression;
    }

    @Override
    public Class<?> getValueClass() {
        String className;
        if (this.valueClass == null && (className = this.getValueClassRealName()) != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_BUCKET_LOAD_ERROR, null, e);
            }
        }
        return this.valueClass;
    }

    private String getValueClassRealName() {
        if (this.valueClassRealName == null) {
            this.valueClassRealName = JRClassLoader.getClassRealName(this.valueClassName);
        }
        return this.valueClassRealName;
    }

    @Override
    public List<DataLevelBucketProperty> getBucketProperties() {
        return this.bucketProperties;
    }

    @Override
    public Object clone() {
        BaseDataLevelBucket clone = null;
        try {
            clone = (BaseDataLevelBucket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        clone.labelExpression = JRCloneUtils.nullSafeClone(this.labelExpression);
        clone.comparatorExpression = JRCloneUtils.nullSafeClone(this.comparatorExpression);
        clone.bucketProperties = JRCloneUtils.cloneList(this.bucketProperties);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.orderValue != null && this.order == null) {
            this.order = BucketOrder.fromSortOrderEnum(this.orderValue);
            this.orderValue = null;
        }
    }
}

