/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public abstract class JRDesignElement
extends JRBaseElement {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ELEMENT_GROUP = "elementGroup";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_KEY = "key";
    public static final String PROPERTY_PRINT_WHEN_EXPRESSION = "printWhenExpression";
    public static final String PROPERTY_PRINT_WHEN_GROUP_CHANGES = "printWhenGroupChanges";
    public static final String PROPERTY_PARENT_STYLE = "parentStyle";
    public static final String PROPERTY_PARENT_STYLE_NAME_REFERENCE = "parentStyleNameReference";
    public static final String PROPERTY_Y = "y";
    public static final String PROPERTY_PROPERTY_EXPRESSIONS = "propertyExpressions";
    private List<JRPropertyExpression> propertyExpressions = new ArrayList<JRPropertyExpression>();

    protected JRDesignElement(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
        this.positionTypeValue = PositionTypeEnum.FIX_RELATIVE_TO_TOP;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public void setKey(String key) {
        String old = this.key;
        this.key = key;
        this.getEventSupport().firePropertyChange(PROPERTY_KEY, old, this.key);
    }

    public void setY(int y) {
        int old = this.y;
        this.y = y;
        this.getEventSupport().firePropertyChange(PROPERTY_Y, old, this.y);
    }

    public void setHeight(int height) {
        int old = this.height;
        this.height = height;
        this.getEventSupport().firePropertyChange(PROPERTY_HEIGHT, old, this.height);
    }

    public void setPrintWhenExpression(JRExpression expression) {
        JRExpression old = this.printWhenExpression;
        this.printWhenExpression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_PRINT_WHEN_EXPRESSION, old, this.printWhenExpression);
    }

    public void setPrintWhenGroupChanges(JRGroup group) {
        JRGroup old = this.printWhenGroupChanges;
        this.printWhenGroupChanges = group;
        this.getEventSupport().firePropertyChange(PROPERTY_PRINT_WHEN_GROUP_CHANGES, old, this.printWhenGroupChanges);
    }

    public void setElementGroup(JRElementGroup elementGroup) {
        JRElementGroup old = this.elementGroup;
        this.elementGroup = elementGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_ELEMENT_GROUP, old, this.elementGroup);
    }

    public void setStyle(JRStyle style) {
        JRStyle old = this.parentStyle;
        this.parentStyle = style;
        this.getEventSupport().firePropertyChange(PROPERTY_PARENT_STYLE, old, this.parentStyle);
    }

    public void setStyleNameReference(String styleName) {
        String old = this.parentStyleNameReference;
        this.parentStyleNameReference = styleName;
        this.getEventSupport().firePropertyChange(PROPERTY_PARENT_STYLE_NAME_REFERENCE, old, this.parentStyleNameReference);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.propertyExpressions == null) {
            this.propertyExpressions = new ArrayList<JRPropertyExpression>();
        }
    }

    public void addPropertyExpression(JRPropertyExpression propertyExpression) {
        this.propertyExpressions.add(propertyExpression);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PROPERTY_EXPRESSIONS, propertyExpression, this.propertyExpressions.size() - 1);
    }

    public void removePropertyExpression(JRPropertyExpression propertyExpression) {
        int idx = this.propertyExpressions.indexOf(propertyExpression);
        if (idx >= 0) {
            this.propertyExpressions.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PROPERTY_EXPRESSIONS, propertyExpression, idx);
        }
    }

    public JRPropertyExpression removePropertyExpression(String name) {
        JRPropertyExpression removed = null;
        ListIterator<JRPropertyExpression> it = this.propertyExpressions.listIterator();
        while (it.hasNext()) {
            JRPropertyExpression prop = it.next();
            if (!name.equals(prop.getName())) continue;
            removed = prop;
            int idx = it.previousIndex();
            it.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PROPERTY_EXPRESSIONS, removed, idx);
            break;
        }
        return removed;
    }

    public List<JRPropertyExpression> getPropertyExpressionsList() {
        return this.propertyExpressions;
    }

    @Override
    public JRPropertyExpression[] getPropertyExpressions() {
        JRPropertyExpression[] props = this.propertyExpressions.isEmpty() ? null : this.propertyExpressions.toArray(new JRPropertyExpression[this.propertyExpressions.size()]);
        return props;
    }

    @Override
    public Object clone() {
        JRDesignElement clone = (JRDesignElement)super.clone();
        clone.uuid = null;
        clone.propertyExpressions = JRCloneUtils.cloneList(this.propertyExpressions);
        return clone;
    }
}

